/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile'
	, 'hbs!applets/wound-care-applet/templates/bradenScaleTemplate'
	, 'hbs!applets/wound-care-applet/templates/empty'
	,	'applets/wound-care-applet/util'],
	function (Portal, Backbone, Marionette, $, _, jqm, template, emptyTemplate, util) {
		'use strict';
		var calc, form, that, sum;
		return Backbone.Marionette.ItemView.extend({
				className: "applet  scrollable", //scrollable-main
				id: 'wound-care',
				template: template,
				events: {
					'change input':'inputSelected',
					'submit form': 'complete',
					'autosave': "autosaveEvent",
					'write-to-note': 'disableInputs'
				},
				templateHelpers: function () {
					return this.model.bradenPlus;
				},
				initialize:function(options){
					that = this;
					that.vent = options.vent || new Backbone.Wreqr.EventAggregator();
					that.listenTo(that.vent, 'note-writer-close', that.enableView  );
					that.listenTo(that.vent, 'note-writer-open', that.disableView );
					// TODO: Oh my
					if( $("#clinic-event.ui-panel-open").length === 1  )
					{
						that.disableView();
					}
				},
				disableView:function(){
					console.log("disable forms");
					this.template = emptyTemplate;
					this.render();this.onShow();
				},
				enableView:function(){
					console.log("ebable forms");
					this.template = template;
					this.render();this.onShow();
				},
				autosaveEvent:function(){
						console.log("save");
						that.gatherData( true );
						that.sendData();
				},
				onShow: function () {
					that = this;
					//that.disableInputs();
					$('#applet-title h2').html('Braden Scale Assessment');
					console.log(this.model);
					this.$el.trigger('create');
					calc = this.el.querySelector('#calculate');
					form = this.el.querySelector('form');
					this.infoTip();
					//this._trigger("")
					this.vent.trigger("show");
//					this.$el.attr('style', Portal.scrollableZoneHeight());
					_.each( this.model.get("bradenAssessment") , function(val, key){
						that.selectSingleItem( $('input[name="'+ key +'"][value="'+val+'"]') );
					});
				},
				disableInputs:function(){
					if (this.model.get('bradenAssessment').status === 'WRITTEN_TO_NOTE') {
						this.$el.find('input').prop('disabled',true);
						this.$el.find('textarea').prop('disabled',true);
						this.$el.find('button').prop('disabled',true);
					}
				},
				infoTip: function () {
					util.infoTip();
				},
				inputSelected: function(e) {
					calc.disabled = false;
					//console.log($(e.currentTarget));
					this.selectSingleItem( $(e.currentTarget) );
				},
				selectSingleItem:function($t){
					var $h2 = $t.parents('div.ui-collapsible-content').eq(0).siblings('h2');
					$h2.find('.number-display').html(': ' + $t.val());
					var $rem = $h2.find('.incomplete');
					if ($rem)
						$rem.remove();
					$t.prop('checked', true).checkboxradio('refresh');
				},
				complete: function (e) {
					e.preventDefault();
					that.gatherData();
					that.sendData();
					return false;
				},
				gatherData:function ( doNotSubmit ){
					var tempAssessment = this.model.get('bradenAssessment');
					var  canSubmit = true, shouldSubmit = !doNotSubmit ;
					sum = 0;
					_.every(this.model.bradenPlus.braden, function (ele, key) {
						console.log(key);
						console.log();
						var $e = $('input[name="'+key+'"]:checked');
						var $ne = $('input[name="'+key+'"]').eq(0),
							$neh2 = $ne.parents('div.ui-collapsible').find('h2');

						if($e.val()) {
							var num = $e.val();
							tempAssessment[$e.attr('name')] = num;
							sum += parseInt(num,10);
							return true;
						}
						else {

							calc.disabled = true;
							canSubmit = false;
							if( shouldSubmit ){
								$neh2.click();
								$neh2.find('.ui-btn-text').append(' <span class="incomplete"> Incomplete</span>');
							}
						}
					});
					if ( shouldSubmit && canSubmit ) {
						tempAssessment.status = "COMPLETE";
					} else {
						tempAssessment.status = "ACTIVE";
					}
				},
				sendData: function (){
					this.model.save({}, {
						success: function () {
							console.log('success');
							if( that.model.get("bradenAssessment").status === "COMPLETE") {
								window.location.hash = 'braden-review/' + sum;
							}
						},
						fail: function () {
							console.log('failure');
						},
						error: function () {
							console.log('error');
						}
					});
				}
			});
	});